Ext.data.JsonP.sol_common_as_renderer_Word({"tagname":"class","name":"sol.common.as.renderer.Word","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.as.renderer.Word.js","href":"lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloas":true,"requires":["sol.common.RepoUtils","sol.common.Template"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"copyMetaData","tagname":"cfg","owner":"sol.common.as.renderer.Word","id":"cfg-copyMetaData","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.as.renderer.Word","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.as.renderer.Word","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"targetId","tagname":"cfg","owner":"sol.common.as.renderer.Word","id":"cfg-targetId","meta":{}},{"name":"templateId","tagname":"cfg","owner":"sol.common.as.renderer.Word","id":"cfg-templateId","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"render","tagname":"method","owner":"sol.common.as.renderer.Word","id":"method-render","meta":{"private":true}},{"name":"renderWord","tagname":"method","owner":"sol.common.as.renderer.Word","id":"method-renderWord","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.as.renderer.Word","short_doc":"Rendering Word file from a Word template. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.as.renderer.Word</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word' target='_blank'>lib_sol.common.as.renderer.Word.js</a></div></pre><div class='doc-contents'><p>Rendering Word file from a Word template.</p>\n\n<p>This can either be used for creating a new Document in the archive (<code>objId</code> specified) or can create a new version on an existing object (<code>parentId</code>).</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-copyMetaData' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Word'>sol.common.as.renderer.Word</span><br/><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word-cfg-copyMetaData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Word-cfg-copyMetaData' class='name expandable'>copyMetaData</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nIf <code>true</code>, the mask and the metadata of the template will be copied to the new document</p>\n</div><div class='long'><p>(optional)\nIf <code>true</code>, the mask and the metadata of the template will be copied to the new document</p>\n</div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Word'>sol.common.as.renderer.Word</span><br/><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Word-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nThe rendered document will be saved as a version of this object\nEither <code>targetId</code> or <code>objId</code> has to be defined.</p>\n</div><div class='long'><p>(optional)\nThe rendered document will be saved as a version of this object\nEither <code>targetId</code> or <code>objId</code> has to be defined.</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Word'>sol.common.as.renderer.Word</span><br/><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Word-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;templateId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-targetId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Word'>sol.common.as.renderer.Word</span><br/><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word-cfg-targetId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Word-cfg-targetId' class='name expandable'>targetId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nThe target folder to store the rendered document</p>\n</div><div class='long'><p>(optional)\nThe target folder to store the rendered document</p>\n</div></div></div><div id='cfg-templateId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Word'>sol.common.as.renderer.Word</span><br/><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word-cfg-templateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Word-cfg-templateId' class='name expandable'>templateId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(reqiured)\nThe template which should be rendered</p>\n</div><div class='long'><p>(reqiured)\nThe template which should be rendered</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-render' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Word'>sol.common.as.renderer.Word</span><br/><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Word-method-render' class='name expandable'>render</a>( <span class='pre'>name, data</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-renderWord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.renderer.Word'>sol.common.as.renderer.Word</span><br/><a href='source/lib_sol.common.as.renderer.Word.html#sol-common-as-renderer-Word-method-renderWord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.renderer.Word-method-renderWord' class='name expandable'>renderWord</a>( <span class='pre'>data, config</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true}});